(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     74173,       2061]*)
(*NotebookOutlinePosition[     74922,       2087]*)
(*  CellTagsIndexPosition[     74878,       2083]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Transformada de Fourier Discreta Bidimensional. Filtrado en frecuencia.\
\>", "Title"],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell["\<\
Los siguientes comandos cargan todos los paquetes gr\[AAcute]ficos y \
establecen opciones por defecto para algunos comandos que usaremos en este \
cuaderno.\
\>", "Text"],

Cell[BoxData[{
    \(\(<< Graphics`;\)\), "\[IndentingNewLine]", 
    \(<< LinearAlgebra`MatrixManipulation`\), "\[IndentingNewLine]", 
    \(\(SetOptions[ListDensityPlot, Mesh \[Rule] False, Frame \[Rule] False, 
        AspectRatio \[Rule] Automatic];\)\), "\[IndentingNewLine]", 
    \(\(SetOptions[ListPlot3D, 
        Mesh \[Rule] False];\)\), "\[IndentingNewLine]", 
    \(\(SetOptions[Fourier, 
        FourierParameters \[Rule] {\(-1\), \(-1\)}];\)\), \
"\[IndentingNewLine]", 
    \(\(SetOptions[InverseFourier, 
        FourierParameters \[Rule] {\(-1\), \(-1\)}];\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetDirectory["\<D:/Docencia \
Informatica/Javier/Ingenieria_Informatica/Curso2006_2007/Calculo \
Avanzado/practicas/06_imagenes/\>"];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Fourier Discreta bidimensional", "Section"],

Cell[TextData[{
  "La Transformada de Fourier Discreta en dos dimensiones (2D-DFT) de una \
matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " donde",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(0 \[LessEqual] m \[LessEqual] 
        M - 1\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  " es la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  " donde",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(0 \[LessEqual] p \[LessEqual] M - 1\ , 
      0 \[LessEqual] q \[LessEqual] \(\(N\)\(-\)\(1\)\(\ \)\)\)\)\)]],
  "(ambas matrices se consideran en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  ") cuyos elementos vienen dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(F(p, q)\), "=", 
                RowBox[{\(1\/\(M\ N\)\), 
                  RowBox[{
                    UnderoverscriptBox[
                      StyleBox["\[Sum]",
                        FontSize->8], \(m = 0\), \(M - 
                        1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                            0\)\%\(N - 1\)\) \(f(m, 
                        n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(m\ p\)\/M + \(n\ q\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                        0 \[LessEqual] p \[LessEqual] M - 1\ , 
                        0 \[LessEqual] q \[LessEqual] N - 1)\)\(\ \)\)}]}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (1) tienen perfecto sentido para enteros cualesquiera \
",
  Cell[BoxData[
      \(TraditionalForm\`p, q \[Element] \[DoubleStruckCapitalZ]\)]],
  " y, en virtud de la periodicidad de la exponencial compleja, se verifica \
que ",
  Cell[BoxData[
      \(TraditionalForm\`F(p + M, q + N) = F(p, q)\)]],
  ", en la teor\[IAcute]a de la 2D-DFT se interpreta siempre la se\[NTilde]al \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el espacio de la frecuencia y \
doblemente peri\[OAcute]dica con per\[IAcute]odos ",
    FontWeight->"Bold"],
  StyleBox["M",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" y ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(F(p + M, q + N) = F(p, q)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" para todos ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`p, q \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ". Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`1/M\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`1/N\)]],
  " son la",
  StyleBox[" frecuencia fundamental",
    FontWeight->"Bold"],
  " ",
  StyleBox["horizontal y vertical",
    FontWeight->"Bold"],
  " respectivamente en (1)."
}], "Text"],

Cell["A su vez la se\[NTilde]al original se puede expresar en la forma", \
"Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(f(m, n)\), "=", 
                RowBox[{
                  UnderoverscriptBox[
                    StyleBox["\[Sum]",
                      FontSize->8], \(p = 0\), \(M - 
                      1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(q = 
                          0\)\%\(N - 1\)\) \(F(p, 
                      q)\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \(\[Pi](\ \
\(m\ p\)\/M + \(n\ q\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                      0 \[LessEqual] m \[LessEqual] M - 1\ , 
                      0 \[LessEqual] n \[LessEqual] N - 1)\)\(\ \)\)}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (2) tienen perfecto sentido para cualesquiera enteros \
",
  Cell[BoxData[
      \(TraditionalForm\`m, n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`f(m + M, n + N) = f(m, n)\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el dominio espacial y \
doblemente peri\[OAcute]dica con per\[IAcute]odos ",
    FontWeight->"Bold"],
  StyleBox["M",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" y ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(f(m + M, n + N) = f(m, n)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" para todos ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`m, n \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  "Consecuencia inmediata de las igualdades (1) y (2) es que la DFT es una \
biyecci\[OAcute]n lineal de  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  " sobre  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^\(M\[Times]N\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Transformada simb\[OAcute]lica 2D-DFT", "Subsection"],

Cell[TextData[{
  "Es f\[AAcute]cil definir un comando que calcule simb\[OAcute]licamente la \
2D-DFT de una matriz. Para ello es conveniente escribir la igualdad (1) de \
forma que se adapte mejor a la notaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{\(F(p, q)\), "=", 
                RowBox[{\(1\/\(M\ N\)\), 
                  RowBox[{
                    UnderoverscriptBox[
                      StyleBox["\[Sum]",
                        FontSize->8], \(m = 1\), 
                      "M"], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                            1\)\%N\) \(f(m, 
                        n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(\((m - 1)\) \((p - 1)\)\)\/M + \(\((n - 1)\) \((q - \
1)\)\)\/N)\)\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                        1 \[LessEqual] p \[LessEqual] M\ , 
                        1 \[LessEqual] q \[LessEqual] N)\)\(\ \)\)}]}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Observamos que cada elemento ",
  Cell[BoxData[
      \(TraditionalForm\`F(p, q)\)]],
  " se obtiene multiplicando elemento a elemento la ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(matriz\)\(\ \)\(\((f(m, n))\)\_\(M\[Times]
              N\)\)\(\ \)\)\)]],
  "por la matriz compleja conjugada de ",
  Cell[BoxData[
      \(TraditionalForm\`W\_\((p, q)\) = \(1\/\(M\ N\)\) \((Exp(\(\((m - 1)\) \
\((p - 1)\)\)\/M, \(\((n - 1)\) \((q - 1)\)\)\/N))\)\_\(1 \[LessEqual] m \
\[LessEqual] M, 1 \[LessEqual] n \[LessEqual] N\)\)]],
  " y sumando todos los elementos de la matriz resultante."
}], "Text"],

Cell[BoxData[{
    RowBox[{\(W[p_, q_, M_, N_] := \(1\/\(M*N\)\) 
            Table[Exp[
                2  \[ImaginaryI]\ \[Pi] \((\ \((m - 1)\) \((\ p - 1)\)/
                          N + \((n - 1)\) \((q - 1)\)/N)\)], {m, 1, M}, {n, 
                1, N}];\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"las", " ", "matrices", " ", 
            FormBox[\(W\_\((p, q)\)\),
              "TraditionalForm"]}], ",", 
          " ", \(1 \[LessEqual] p \[LessEqual] M\), 
          ",", \(1 \[LessEqual] q \[LessEqual] N\), ",", 
          " ", \(en\ \[DoubleStruckC]\^\(M\[Times]N\)\)}], "*)"}], 
      ";"}], "\[IndentingNewLine]", \(W[p_, q_, M_] := 
      W[p, q, M, M]\)}], "Input"],

Cell["\<\
El siguiente comando calcula simb\[OAcute]licamente la 2D-DFT de una \
matriz.\
\>", "Text"],

Cell[BoxData[{
    \(dft2Dmtrx[matriz_?MatrixQ] := 
      Module[{m = \(Dimensions[matriz]\)[\([1]\)], 
          n = \(Dimensions[matriz]\)[\([2]\)]}, 
        Map[Total, 
            Map[Total, 
              Table[Conjugate[W[p, q, m, n]]*matriz, {p, 1, m}, {q, 1, 
                  n}], {2, 2}], {2, 2}] // 
          Simplify]\), "\[IndentingNewLine]", 
    \(dft2Dmtrx[
        otracosa_] := "\<El argumento debe ser una matriz\>"\)}], "Input"],

Cell[BoxData[{
    \(\(a = 
        Table[Random[Integer, {1, 10}], {j, 4}, {k, 
            4}];\)\), "\[IndentingNewLine]", 
    \(dft2Dmtrx[a]\)}], "Input"],

Cell[TextData[{
  "El comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Fourier[ ] calcula transformadas de Fourier discretas de listas anidadas \
de cualquier dimensi\[OAcute]n. En particular calcula  la 2D-DFT, es decir, \
la transformada de Fourier discreta de una matriz. Es un comando que solo \
trabaja num\[EAcute]ricamente."
}], "Text"],

Cell[BoxData[{
    \(Fourier[a] // Chop\), "\[IndentingNewLine]", 
    \(dft2Dmtrx[a] // N\)}], "Input"],

Cell[TextData[{
  "Podemos convertir las matrices ",
  Cell[BoxData[
      \(TraditionalForm\`W\_\((p, q)\)\)]],
  " en vectores como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(V[p_, q_, M_, N_] := 
        Flatten[W[p, q, M, N]];\)\), "\[IndentingNewLine]", 
    \(\(V[p_, q_, M_] := Flatten[W[p, q, M]];\)\)}], "Input"],

Cell[TextData[{
  "Estos vectores forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[DoubleStruckCapitalC]\^\(M\[Times]
            N\)\)\(\ \)\)\)]],
  " como comprobamos seguidamente para ",
  Cell[BoxData[
      \(TraditionalForm\`M = \(N = 3\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Simplify[
      Table[Conjugate[V[k, j, 3]] . V[p, q, 3], {k, 1, 3}, {j, 1, 3}, {p, 1, 
          3}, {q, 1, 3}]]\)], "Input"],

Cell["\<\
De hecho, podemos calcular la 2D-DFT de una matriz trat\[AAcute]ndola como un \
vector.\
\>", "Text"],

Cell[BoxData[
    \(Table[Flatten[a] . Conjugate[V[p, q, 4]], {p, 1, 4}, {q, 1, 4}] // 
      Simplify\)], "Input"],

Cell[BoxData[{
    \(dft2Dvector[matriz_?MatrixQ] := 
      Module[{m = \(Dimensions[matriz]\)[\([1]\)], 
            n = \(Dimensions[matriz]\)[\([2]\)]}, 
          Table[Flatten[matriz] . Conjugate[V[p, q, m, n]], {p, 1, m}, {q, 1, 
              n}]] // Simplify\), "\[IndentingNewLine]", 
    \(dft2Dvector[
        otracosa_] := "\<El argumento debe ser una matriz\>"\)}], "Input"],

Cell[BoxData[{
    \(\(a = 
        Table[Random[Integer, {1, 10}], {j, 4}, {k, 
            4}];\)\), "\[IndentingNewLine]", 
    \(dft2Dmtrx[a] == dft2Dvector[a]\), "\[IndentingNewLine]", 
    \(N[dft2Dmtrx[a]] \[Equal] Fourier[a] // Chop\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada num\[EAcute]rica 2D-DFT", "Subsection"],

Cell[TextData[{
  "Una propiedad muy \[UAcute]til de la 2D-DFT es que es separable, esto es, \
puede calcularse en dos etapas haciendo sucesivas 1D-DFT. Para ello, basta \
notar que calculando las transformadas 1D-DFT de las filas de la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " obtenemos una matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Z",
            FontWeight->"Bold"], "=", \((Z(m, q))\), " "}], 
        TraditionalForm]]],
  " cuyos elementos viene dados por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(Z(m, 
                  q) = \(\(1\/\(\(N\)\(\ \)\)\) \(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \
\)\)\)\+\(n = 0\)\%\(N - 1\)\) \(f(m, 
                    n)\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi] \( \
n\ q\)\/N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \)\((\ 
                    0 \[LessEqual] m \[LessEqual] M - 1\ , 
                    0 \[LessEqual] q \[LessEqual] N - 1)\)\(\ \)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell["\<\
Y calculando las 1D-DFT de las columnas de esta matriz obtenemos la 2D-DFT de \
la matriz inicial.\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            RowBox[{\(1\/\(\(M\)\(\ \)\)\), 
              RowBox[{
                UnderoverscriptBox[
                  StyleBox["\[Sum]",
                    FontSize->8], \(m = 0\), \(M - 1\)], \(\(Z(m, 
                    q)\)\ \ \ \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi] \
\( m\ p\)\/M\)\)}]}],
            FontWeight->"Bold"], 
          StyleBox["    ",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox[
              FormBox[
                RowBox[{
                  RowBox[{\(1\/\(M\ N\)\), 
                    RowBox[{
                      UnderoverscriptBox[
                        StyleBox["\[Sum]",
                          FontSize->8], \(m = 0\), \(M - 
                          1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(n = 
                              0\)\%\(N - 1\)\) \(f(m, 
                          n)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \(\
\[Pi](\ \(m\ p\)\/M + \(n\ q\)\/N)\)\)\)}]}], "   ", "="}],
                "TraditionalForm"],
              FontWeight->"Bold"], 
            StyleBox["   ",
              FontWeight->"Bold"], 
            StyleBox[\(F(p, q)\),
              FontWeight->"Bold"], "          "}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell["\<\
El siguiente comando calcula num\[EAcute]ricamente la 2D-DFT de una matriz: \
primero se calculan las 1D-DFT de las filas y despu\[EAcute]s se calculan las \
1D-DFT de las  columnas de la matriz obtenida.\
\>", "Text"],

Cell[BoxData[{
    \(dft2D[matriz_?MatrixQ] := 
      Transpose[
        Map[Fourier, 
          Transpose[Map[Fourier, matriz]]]]\), "\[IndentingNewLine]", 
    \(dft2D[otracosa_] := "\<El argumento debe ser una matriz\>"\)}], "Input"],

Cell["\<\
El comando definido hace lo mismo que el comando Fourier[ ] sobre matrices. \
Podemos comprobarlo (usamos Chop[ ] para evitar errores de redondeo).\
\>", "Text"],

Cell[BoxData[
    \(m = Partition[Table[Random[], {256*256}], 256];  (*\ 
      256  filas\ y\ 256\ columnas\ *) \[IndentingNewLine]Simplify[
      Chop[dft2D[m] - Fourier[m]] \[Equal] 0]\)], "Input"],

Cell[TextData[{
  "El comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es m\[AAcute]s eficaz que el anteriormente definido."
}], "Text"],

Cell[BoxData[{
    \(\(m = 
        Table[Random[], {i, 1024}, {j, 1024}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[Fourier[m]]\)[\([1]\)]\), "\[IndentingNewLine]", 
    \(\(Timing[dft2D[m]]\)[\([1]\)]\), "\[IndentingNewLine]", 
    \(Clear[m]\)}], "Input"],

Cell["Como es de esperar, los comandos simb\[OAcute]licos son muy lentos.", \
"Text"],

Cell[BoxData[{
    \(\(m = Table[Random[], {i, 16}, {j, 16}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[dft2Dmtrx[m]]\)[\([1]\)]\), "\[IndentingNewLine]", 
    \(\(Timing[dft2Dvector[m]]\)[\([1]\)]\), "\[IndentingNewLine]", 
    \(Clear[a, m]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Propiedades de simetr\[IAcute]a de la 2D-DFT", "Subsection"],

Cell[TextData[{
  "Teniendo en cuenta las propiedades de simetr\[IAcute]a de la 1D-DFT se \
deduce que la 2D-DFT de una ",
  StyleBox["matriz real",
    FontWeight->"Bold"],
  " es ",
  StyleBox["hemisim\[EAcute]trica",
    FontWeight->"Bold"],
  " respecto del valor ",
  Cell[BoxData[
      \(TraditionalForm\`F(M/2, N/2)\)]],
  ", esto es el valor que ocupa el lugar \"central\" ",
  Cell[BoxData[
      \(TraditionalForm\`\((M/2 + 1, N/2 + 1)\)\)]],
  ", siendo ",
  StyleBox["M\[Times]N",
    FontSlant->"Italic"],
  "  las dimensiones de la matriz que se suponen pares. Es decir, para se\
\[NTilde]ales reales, se verifica qe   "
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[\(\(\ \)\(F(M/2 + p, N/2 + q) = \(F\&__\)(M/2 - p, 
            N/2 - q)\)\),
        FontWeight->"Bold"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde la barrita en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F\&__\)\(\ \ \)\)\)]],
  "indica complejo conjugado. El convenio de iniciar los \[IAcute]ndices en 0 \
puede llevar a error pues ",
  Cell[BoxData[
      \(TraditionalForm\`F(M/2, N/2)\)]],
  " ocupa el lugar \"central\"  ",
  Cell[BoxData[
      \(TraditionalForm\`\((M/2 + 1, N/2 + 1)\)\)]],
  " en la transformada, es decir, en la notaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la simetr\[IAcute]a se expresa en la forma"
}], "Text"],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\([\([M/2 + 1 + k, N/2 + 1 + j]\)]\), "=", 
            RowBox[{
              StyleBox[\(F\&__\),
                FontWeight->"Bold"], 
              FormBox[\([\([M/2 + 1 - k, N/2 + 1 - j]\)]\),
                "TraditionalForm"]}]}]}], TraditionalForm]],
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Por ello es costumbre centrar la 2D-DFT de forma que el t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm\`F(0, 0)\)]],
  " ocupe en la matriz transformada el lugar ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \ \)\(\((M/2 + 1, 
          N/2 + 1)\)\(\ \)\(.\)\)\)\)]],
  " El siguiente comando hace esta operaci\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(centrar[matriz_?MatrixQ] := 
      Module[{m = \(Dimensions[matriz]\)[\([1]\)], 
            n = \(Dimensions[matriz]\)[\([2]\)]}, 
          RotateRight[RotateRight[matriz, m/2], {0, n/2}]] /; \((And @@ 
            EvenQ[Dimensions[matriz]])\)\), "\[IndentingNewLine]", 
    \(centrar[
        otracosa_] := "\<El argumento debe ser una matriz de dimensiones \
pares\>"\)}], "Input"],

Cell["\<\
Seguidamente comprobamos la propiedad de hemisimetr\[IAcute]a de la 2D-DFT.\
\>", "Text"],

Cell[BoxData[{
    \(\(m = Partition[Table[Random[], {256*256}], 256];\) (*\ 
      256  filas\ y\ 256\ columnas . \ Lugar\ central\ {129, 
          129}\ *) \), "\[IndentingNewLine]", 
    \(\(m = centrar[Chop[Fourier[m]]];\)\), "\[IndentingNewLine]", 
    \(\(k = 1;\)\), "\[IndentingNewLine]", 
    \(\(For[j = 1, j < 128, 
        While[k < 128 && 
            m[\([129 - k, 129 - j]\)] \[Equal] 
              Conjugate[
                m[\([129 + k, 
                    129 + j]\)]], \(k++\)], \(j++\)];\)\), "\
\[IndentingNewLine]", 
    \({k, j}\), "\[IndentingNewLine]", 
    \(Clear[k, j, m]\)}], "Input"],

Cell[TextData[{
  "Otra forma usual de centrar la transformada consiste en multiplicar el \
elemento ",
  Cell[BoxData[
      \(TraditionalForm\`f(m, n)\)]],
  " de la imagen por ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\))\)\^\(m + n\) = \(\[ExponentialE]\^\(\
\[ImaginaryI]\ \[Pi]\ m\)\) \[ExponentialE]\^\(\[ImaginaryI]\ \[Pi]\ n\)\)]],
  ". "
}], "Text"],

Cell[BoxData[{
    \(dft2Dcentrada[matriz_?MatrixQ] := 
      Module[{temp, m = \(Dimensions[matriz]\)[\([1]\)], 
            n = \(Dimensions[matriz]\)[\([2]\)]}, 
          temp = Normal[
              SparseArray[{{p_, q_} \[Rule] \((\(-1\))\)^\((p + q)\)}, {m, 
                  n}]]; \[IndentingNewLine]Fourier[temp*matriz]] /; \((And @@ 
            EvenQ[Dimensions[matriz]])\)\), "\[IndentingNewLine]", 
    \(dft2Dcentrada[
        otracosa_] := "\<El argumento debe ser una matriz de dimensiones \
pares\>"\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Espectros de amplitudes de algunas se\[NTilde]ales senoidales elementales\
\>", "Section"],

Cell[TextData[{
  "Es costumbre llamar a la transformada 2D-DFT de una se\[NTilde]al \
bidimensional el espectro de la se\[NTilde]al y a sus elementos coeficientes \
espectrales. El espectro de amplitudes es la matriz formada por los \
m\[OAcute]dulos de los elementos del espectro (es una matriz \
sim\[EAcute]trica respecto del lugar central (M/2+1,N/2+1)) y el espectro de \
fases es la matriz formada por los argumentos de los elementos del espectro. \
Podemos representar con ListDensityPlot[ ] los espectros de amplitudes y de \
fases de una imagen. Vamos a usar im\[AAcute]genes sencillas para que podamos \
apreciar en qu\[EAcute] forma las caracter\[IAcute]sticas de la imagen quedan \
reflejadas en los espectros. El siguiente comando muestrea una \
funci\[OAcute]n de dos variables con una raz\[OAcute]n de muestreo \
determinada durante cierto tiempo y proporciona las im\[AAcute]genes de la \
muestra obtenida y de su espectro de amplitudes. Para aumentar el rango din\
\[AAcute]mico del espectro de amplitudes usamos la transformaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`0.5 \(\( Log[1 + x]\)\(\ \)\(.\)\)\)]]
}], "Text"],

Cell[BoxData[{
    \(\(muestra[func_, razonmuestreo_, tiempo_] := 
        Module[{nummuestras}, nummuestras = Floor[tiempo*razonmuestreo]; 
          Table[func[x, y], {x, 0.0, \((nummuestras - 1)\)/razonmuestreo, 
              1/N[razonmuestreo]}, {y, 
              0.0, \((nummuestras - 1)\)/razonmuestreo, 
              1/N[razonmuestreo]}]];\)\), "\n", 
    \(espectrumPlot[func_, razonmuestreo_, tiempo_] := 
      Module[{valores, tmpdft}, 
        valores = 
          muestra[func, razonmuestreo, tiempo]; \[IndentingNewLine]tmpdft = 
          centrar[Abs[
              Chop[Fourier[valores, 
                  FourierParameters \[Rule] {\(-1\), \(-1\)}]]]]; \
\[IndentingNewLine]graf1 = 
          ListDensityPlot[valores, DisplayFunction \[Rule] Identity]; \n
        graf2 = ListDensityPlot[0.5*Log[1 + tmpdft], 
            DisplayFunction \[Rule] Identity]; \n
        Show[GraphicsArray[{graf1, graf2}], 
          ImageSize \[Rule] {449.25, 
              213.75}];\[IndentingNewLine]]\)}], "Input"],

Cell["\<\
La siguiente funci\[OAcute]n \"onda[ ]\" es una sinusoide con una \
\[UAcute]nica frecuencia igual a 32 hercios en la direcci\[OAcute]n \
horizontal y amplitud 10. Representamos la imagen obtenida por muestreo de la \
se\[NTilde]al y su espectro de amplitudes.\
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 10  Cos[32\ 2\ Pi\ y]\ ;\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 128, 1]\)}], "Input"],

Cell["\<\
En el espectro de amplitudes se aprecian solamente dos puntitos blancos que \
son los \[UAcute]nicos valores positivos del mismo y que representan la \
\[UAcute]nica frecuencia presente en la muestra. Veamos en d\[OAcute]nde est\
\[AAcute]n los dos \[UAcute]nicos valores positivos del espectro.\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 128, 1]]]]];\)\), "\[IndentingNewLine]", 
    \({Select[Flatten[dftimg], Positive], Position[dftimg, _?\((# > 0 &)\)]} // 
      Transpose\)}], "Input"],

Cell["\<\
Observamos que est\[AAcute]n en la fila central (la fila 65) en las columnas \
33=65-32 y 97=65+32 por lo que son sim\[EAcute]tricos respecto al centro de \
la fila. Adem\[AAcute]s, su valor es igual a 5 que es la mitad de la amplitud \
de la se\[NTilde]al muestreada.\
\>", "Text"],

Cell["\<\
Veamos lo que sucede para una se\[NTilde]al sinusoidal con frecuencia \
solamente en la direcci\[OAcute]n vertical.\
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 10  Cos[32\ 2\ Pi\ x];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 128, 1]\)}], "Input"],

Cell["\<\
La funci\[OAcute]n onda[ ] es ahora una sinusoide con una \[UAcute]nica \
frecuencia igual a 32 hercios en la direcci\[OAcute]n vertical y amplitud 10. \
En el espectro de amplitudes se aprecian solamente dos valores positivos que \
representan la \[UAcute]nica frecuencia presente en la muestra. Veamos en d\
\[OAcute]nde est\[AAcute]n los dos \[UAcute]nicos valores positivos del \
espectro.\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 128, 1]]]]];\)\), "\[IndentingNewLine]", 
    \({Select[Flatten[dftimg], Positive], Position[dftimg, _?\((# > 0 &)\)]} // 
      Transpose\)}], "Input"],

Cell["\<\
Observamos que est\[AAcute]n en la columna central (la 65) en las filas \
33=65-32 y 97=65+32. Adem\[AAcute]s, su valor es igual a 5 que es la mitad de \
la amplitud de la se\[NTilde]al muestreada.\
\>", "Text"],

Cell["\<\
Veamos lo que sucede para una se\[NTilde]al sinusoidal con frecuencia \
solamente en la direcci\[OAcute]n de la bisectriz del primer cuadrante.\
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 
        10  Cos[2\ Pi \((32\ x + 32\ y)\)]\ ;\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 128, 1]\)}], "Input"],

Cell["\<\
Comprobemos que los dos valores positivos del espectro est\[AAcute]n situados \
en la bisectriz sim\[EAcute]tricamente respecto del lugar (65,65) (que \
representa la componente de frecuencia nula).\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 128, 1]]]]];\)\), "\[IndentingNewLine]", 
    \({Select[Flatten[dftimg], Positive], Position[dftimg, _?\((# > 0 &)\)]} // 
      Transpose\)}], "Input"],

Cell["Consideremos una se\[NTilde]al m\[AAcute]s compleja.", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 
        10  Cos[2\ Pi\ \((12  x\  + \ 58\ y)\)] + \ 
          8  Cos[2\ Pi \((32\ x\  + \ 
                    8\ y)\)]\ ;\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 128, 1]\)}], "Input"],

Cell["\<\
Ahora hay 4 valores positivos que representan las 4 frecuencias presentes y \
que son iguales a la mitad de las respectivas amplitudes.\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 128, 1]]]]];\)\), "\[IndentingNewLine]", 
    \(\({Select[Flatten[dftimg], Positive], 
          Position[dftimg, _?\((# > 0 &)\)]} // Transpose\) // 
      Sort\)}], "Input"],

Cell["Observa las igualdades", "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\((33, 57)\) = \((65, 65)\) - \((32, 8)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((97, 73)\) = \((65, 65)\) + \((32, 8)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((53, 7)\) = \((65, 65)\) - \((12, 58)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((77, 123)\) = \((65, 65)\) + \((12, 58)\)\)]],
  ". "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Deducimos que en el espectro de amplitudes corresponden a cada \
componente senoidal del tipo ACos[p 2 Pi x + q 2 Pi y] dos coeficientes \
iguales a A/2 situados sim\[EAcute]tricamente respecto al lugar central y \
desplazados p filas y q columnas respecto del mismo. Por tanto, los \
coeficientes que representan las frecuencias ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\((p, q)\)\(\ \)\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox["est\[AAcute]n situados a una distancia ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\@\(p\^2 + q\^2\)\),
            FontWeight->"Bold"], " "}], TraditionalForm]]],
  StyleBox["del centro de la transformada. Este dato se usa para \
dise\[NTilde]ar filtros en frecuencia como despu\[EAcute]s veremos.",
    FontWeight->"Bold"]
}], "Text"],

Cell["\<\
Cuando hay componentes seno y coseno con iguales frecuencias horizontal y \
vertical los valores correspondientes del espectro son iguales a la mitad de \
la norma eucl\[IAcute]dea de las amplitudes respectivas. \
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 
        16  Cos[2\ Pi \((32\ x\  + \ 16  y)\)] + 
          8  Sin[2  Pi \((32\ x\  + \ 16\ y)\)];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 256, 1]\)}], "Input"],

Cell["\<\
Se trata de una se\[NTilde]al con dos componentes sinusoidales de igual \
frecuencia horizontal y vertical con amplitudes 16 y 8.\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 256, 1]]]]];\)\), "\[IndentingNewLine]", 
    \(\({Select[Flatten[dftimg], Positive], 
          Position[dftimg, _?\((# > 0 &)\)]} // Transpose\) // 
      Sort\), "\[IndentingNewLine]", 
    \(0.5 \@\( 16\^2 + 8\^2\)\)}], "Input"],

Cell["\<\
Consideremos ahora una se\[NTilde]al con seis componentes senoidales.\
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 
        Sum[\((15 - p - q)\) Cos[2  Pi \((4*p^3\ x + q^3\ y)\)], {p, 1, 
            3}, {q, p + 1, p + 2}]\ \ ;\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[onda, 256, 1]\)}], "Input"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[onda, 256, 1]]]]];\)\), "\[IndentingNewLine]", 
    \({Select[Flatten[dftimg], Positive], Position[dftimg, _?\((# > 0 &)\)]} // 
      Transpose\)}], "Input"],

Cell["\<\
El espectro de amplitudes tiene doce valores positivos. Observa c\[OAcute]mo \
en el espectro de amplitudes las frecuencias m\[AAcute]s bajas se representan \
en la zona central. En este caso entre las frecuencias m\[AAcute]s bajas est\
\[AAcute]n (129,129)-(125,121)=(4,8), (129,129)-(125,102)=(4,27), \
(129,129)-(97,102)=(32,27). Mientras que las frecuencias m\[AAcute]s altas \
detectadas son (129,129)-(21,4)=(108,125) que corresponden a los valores m\
\[AAcute]ximos de p=3, q=5. Las frecuencias m\[AAcute]s altas se representan \
en las zonas m\[AAcute]s alejadas del centro del espectro.\
\>", "Text"],

Cell["\<\
Para que la transformada 2D-DFT sea capaz de reflejar todas las frecuencias \
espaciales presentes en una se\[NTilde]al bidimensional, dicha se\[NTilde]al \
debe ser muestreda con una raz\[OAcute]n de muestreo suficientemente alta, \
mayor que el doble que la mayor de las frecuencias espaciales presentes en \
dicha se\[NTilde]al. Vamos a ocuparnos de esto seguidamente.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Muestreo y \"aliasing\"", "Section"],

Cell[CellGroupData[{

Cell["Polinomio interpolador", "Subsection"],

Cell["De la igualdad", "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FormBox[
          RowBox[{\(f(m, n)\), "=", 
            RowBox[{
              UnderoverscriptBox[
                StyleBox["\[Sum]",
                  FontSize->8], \(p = 0\), \(M - 
                  1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(q = 
                      0\)\%\(N - 1\)\) \(F(p, 
                  q)\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \(\[Pi](\ \(m\ \
p\)\/M + \(n\ q\)\/N)\)\)\)\(\ \)\)}]}],
          "TraditionalForm"],
        FontWeight->"Bold"], TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "se deduce que el polinomio trigonom\[EAcute]trico en dos variables de \
periodos ",
  Cell[BoxData[
      \(TraditionalForm\`\((S, T)\)\)]],
  " dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        FormBox[
          RowBox[{\(P(s, t)\), "=", 
            RowBox[{
              UnderoverscriptBox[
                StyleBox["\[Sum]",
                  FontSize->8], \(p = 0\), \(M - 
                  1\)], \(\(\(\(\ \ \ \)\(\(\[Sum]\)\(\ \)\)\)\+\(q = 
                      0\)\%\(N - 1\)\) \(F(p, 
                  q)\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \(\[Pi](\ \(s\ \
p\)\/S + \(t\ q\)\/T)\)\)\)\(\ \)\)}]}],
          "TraditionalForm"],
        FontWeight->"Bold"], TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`f(m\ , n\ ) = P\ \((\(m*S\)\/M, \(n*T\)\/N)\)\)]],
  ". Se trata por ello de un polinomio interpolador para la funci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". ",
  StyleBox["Dicho polinomio est\[AAcute] determinado de manera \[UAcute]nica \
por la 2D-DFT.",
    FontWeight->"Bold"],
  " El siguiente comando calcula este polinomio. "
}], "Text"],

Cell[BoxData[
    \(\(\(interpol2D[muestra_]\)[S_, T_]\)[s_, 
        t_] := \(\(\(Module[{m = \(Dimensions[muestra]\)[\([1]\)], 
                  n = \(Dimensions[muestra]\)[\([2]\)], tmp, tmptriz}, 
                tmp = Chop[Fourier[muestra]]; \[IndentingNewLine]tmptriz = 
                  Table[Exp[
                      2  \[ImaginaryI]\ \[Pi]\ \((\(s*p\)\/S + \
\(t*q\)\/T)\)], {p, \(-m\)\/2, m\/2 - 1}, {q, \(-n\)\/2, 
                      n\/2 - 1}]; \[IndentingNewLine]Total[
                  Total /@ \((centrar[tmp]*tmptriz)\)]\[IndentingNewLine]] // 
              ComplexExpand\) // Simplify\) // TrigReduce\) // 
        Chop\)], "Input"],

Cell["El polinomio trigonom\[EAcute]trico", "Text"],

Cell[BoxData[
    \(\(onda[x_, y_] = 
        10  Cos[2\ Pi \((5\ x\  + \ 3\ \ y)\)] + \ 
          8  Cos[2\ Pi \((7\ x\  + \ 9\ \ y)\)]\  + 
          1.5\ Sin[2\ Pi\ \((3\ x\  - \ 5\ y)\)];\)\)], "Input"],

Cell["\<\
tiene una frecuencia m\[AAcute]xima igual a 9 hercios. Podemos recuperarlo si \
lo muestreamos con una raz\[OAcute]n de muestreo mayor que 18 muestras por \
segundo. \
\>", "Text"],

Cell[BoxData[
    \(\(\(\(\(interpol2D[muestra[onda, 20, 1]]\)[1, 1]\)[x, y]\)\( (*\ 
      recuperamos\ la\ se\[NTilde]al\ *) \)\)\)], "Input"],

Cell["\<\
Pero si muestreamos esta se\[NTilde]al con menor raz\[OAcute]n de muestreo \
perdemos frecuencias presentes en la misma y pueden aparecer frecuencias \
extra\[NTilde]as que no est\[AAcute]n presentes en la se\[NTilde]al dada, \
esto es, se produce \"aliasing\", enmascaramiento de nuestra se\[NTilde]al \
por otra de frecuencia menor.\
\>", "Text"],

Cell[BoxData[
    \(disfraz[x_, y_] = \(\(interpol2D[muestra[onda, 16, 1]]\)[1, 1]\)[x, 
        y]\)], "Input"],

Cell["\<\
Observa que ahora en la se\[NTilde]al recuperada hemos perdido la frecuencia \
m\[AAcute]s alta. Podemos ver las im\[AAcute]genes muestreadas en cada caso. \
\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{ListDensityPlot[muestra[onda, 22, 1], 
              DisplayFunction \[Rule] Identity], 
            ListDensityPlot[muestra[onda, 16, 1], 
              DisplayFunction \[Rule] Identity], 
            ListDensityPlot[muestra[disfraz, 16, 1], 
              DisplayFunction \[Rule] Identity]}, 
          DisplayFunction \[Rule] $DisplayFunction]];\)\)], "Input"],

Cell["\<\
Observa que las dos \[UAcute]ltimas son id\[EAcute]nticas. Es por eso que la \
segunda muestra obtenida con raz\[OAcute]n de muestreo igual a 16 muestras \
por segundo parece proceder de la se\[NTilde]al \"disfraz[ ]\" y no de la se\
\[NTilde]al que realmente la ha producido.\
\>", "Text"],

Cell[BoxData[{
    \(\(onda[x_, y_] = 
        Sum[\((15 - p - q)\) Cos[2  Pi \((4*p^3\ x + q^3\ y)\)], {p, 1, 
            3}, {q, p + 1, p + 2}];\)\[IndentingNewLine] (*\ 
      frecuencia\ m\[AAcute]xima\ 125\ hercios\ *) \), "\[IndentingNewLine]", \

    \(\(\(interpol2D[muestra[onda, 256, 1]]\)[1, 1]\)[x, 
      y]\), "\[IndentingNewLine]", 
    \( (*\ raz\[OAcute]n\ de\ muestreo\ 256, \ 
      se\ recupera\ la\ se\[NTilde]al\ *) \)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Espectros de amplitudes de algunas se\[NTilde]ales no senoidales \
elementales\
\>", "Section"],

Cell["\<\
Teniendo en cuenta que en la imagen de una muestra de una funci\[OAcute]n \
f[x,y] la variable primera representa la dimensi\[OAcute]n vertical y la \
segunda la horizontal, la siguiente funci\[OAcute]n representa una banda \
horizontal.\
\>", "Text"],

Cell[BoxData[{
    \(\(banda[x_, y_] = 
        If[ .475 < x <  .525, 1.0, 0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[banda, 256, 1]\)}], "Input"],

Cell["\<\
Los valores positivos del espectro est\[AAcute]n todos en la columna central.\
\
\>", "Text"],

Cell[BoxData[{
    \(\(dftimg = 
        centrar[Abs[
            Chop[Fourier[
                muestra[banda, 256, 1]]]]];\)\), "\[IndentingNewLine]", 
    \(Select[Flatten[dftimg], Positive] == 
      dftimg[\([All, 129]\)]\), "\[IndentingNewLine]", 
    \(\(ListPlot3D[dftimg];\)\)}], "Input"],

Cell["\<\
Podemos representar gr\[AAcute]ficamente la columna central del espectro de \
amplitudes.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[tmp = dftimg[\([All, 129]\)], 
        Epilog \[Rule] {Line /@ 
              Table[{{k, 0}, {k, tmp[\([k]\)]}}, {k, 1, 256}], Hue[0], 
            PointSize[ .007], 
            Point /@ Table[{k, tmp[\([k]\)]}, {k, 1, 256}]}, 
        PlotRange \[Rule] All];\)\)], "Input"],

Cell["\<\
Esta gr\[AAcute]fica recuerda el espectro de amplitudes de la 1D-DFT de la \
funci\[OAcute]n rect\[AAcute]ngulo. Vamos a calcular el polinomio \
interpolador de esta imagen (tiene 129 sumandos).\
\>", "Text"],

Cell[BoxData[
    \(\(poli[x_, y_] = 
        Re[\(\(interpol2D[muestra[banda, 256, 1]]\)[1, 1]\)[x, 
            y]];\)\)], "Input"],

Cell[BoxData[{
    \(graf1 = 
      Plot3D[poli[x, y], {x, 0, 1}, {y, 0, 1}, PlotPoints \[Rule] 80, 
        PlotRange \[Rule] All, Mesh \[Rule] False, Axes \[Rule] False, 
        DisplayFunction \[Rule] Identity]; 
    graf2 = Plot3D[banda[x, y], {x, 0, 1}, {y, 0, 1}, PlotPoints \[Rule] 80, 
        PlotRange \[Rule] All, Mesh \[Rule] False, Axes \[Rule] False, 
        DisplayFunction \[Rule] Identity];\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{graf1, graf2}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {449.25, 213.75}];\)\)}], "Input"],

Cell["\<\
Como puedes apreciar el polinomio interpolador es una buena aproximaci\
\[OAcute]n de la funci\[OAcute]n.\
\>", "Text"],

Cell["La siguiente se\[NTilde]al es una banda vertical.", "Text"],

Cell[BoxData[{
    \(\(banda[x_, y_] = 
        If[ .475 < y <  .525, 1.0, 0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[banda, 128, 1]\)}], "Input"],

Cell["La siguiente se\[NTilde]al es una funci\[OAcute]n rect\[AAcute]ngulo \
bidimensional.", "Text"],

Cell[BoxData[{
    \(\(rect[x_, y_] = 
        If[ .4 < x <  .6 &&  .4 < y <  .6, 1.0, 
          0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[rect, 128, 1]\)}], "Input"],

Cell["\<\
De hecho se trata de un cuadrado. Observa la perfecta simetr\[IAcute]a de la \
imagen y de su espectro.\
\>", "Text"],

Cell[BoxData[{
    \(\(rect[x_, y_] = 
        If[ .35 < x <  .65 &&  .475 < y <  .525, 1.0, 
          0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[rect, 128, 1]\)}], "Input"],

Cell["\<\
Ahora se trata de un rect\[AAcute]ngulo. Podemos representar \
gr\[AAcute]ficamente la fila central del espectro de amplitudes.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[tmp = dftimg[\([65]\)], 
        Epilog \[Rule] {Line /@ 
              Table[{{k, 0}, {k, tmp[\([k]\)]}}, {k, 1, 128}], Hue[0], 
            PointSize[ .007], 
            Point /@ Table[{k, tmp[\([k]\)]}, {k, 1, 128}]}];\)\)], "Input"],

Cell["\<\
El efecto de girar una imagen se traduce en un giro en sentido opuesto en el \
espectro.\
\>", "Text"],

Cell[BoxData[{
    \(\(G[\[Theta]_] = {{Cos[\[Theta]], Sin[\[Theta]]}, {\(-Sin[\[Theta]]\), 
            Cos[\[Theta]]}};\)\), "\[IndentingNewLine]", 
    \(\(rect[x_, y_] = 
        If[ .35 <  .5 + First[G[Pi/4. ] . {x -  .5, y -  .5}] <  .65\  && \ 
            0.475 <  .5 + Last[G[Pi/4. ] . {x -  .5, y -  .5}] <  .525, 1.0, 
          0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[rect, 128, 1]\)}], "Input"],

Cell["\<\
No pueden faltar los c\[IAcute]rculos (la funci\[OAcute]n \
caracter\[IAcute]sitca de un c\[IAcute]rculo).\
\>", "Text"],

Cell[BoxData[{
    \(\(circulo[x_, y_] = 
        If[\((x -  .5)\)^2 + \((y -  .5)\)^2 < \((0.15)\)^2, 1.0, 
          0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[circulo, 128, 1]\)}], "Input"],

Cell[BoxData[{
    \(\(circulo2[x_, y_] = 
        If[Min[\((x -  .25)\)^2 + \((y -  .25)\)^2, \((x -  .75)\)^2 + \((y - \
 .75)\)^2] < \((0.1)\)^2, 1.0, 0.0];\)\), "\[IndentingNewLine]", 
    \(espectrumPlot[circulo2, 256, 1]\)}], "Input"],

Cell["\<\
Acabamos esta serie de ejemplos con una conocida imagen real.\
\>", "Text"],

Cell[BoxData[{
    \(\(lena = \(Import["\<lena.jpg\>"]\)[\([1, 
            1]\)];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[lena];\)\)}], "Input"],

Cell["Representamos los espectros de amplitudes y de fases", "Text"],

Cell[BoxData[{
    \(\(dftlena = centrar[Chop[Fourier[lena]]];\)\), "\[IndentingNewLine]", 
    \(\(fases[z_] := If[z \[NotEqual] 0.0, Arg[z], 0.0];\)\), "\n", 
    \(\(amplitudes[z_] := Abs[z];\)\), "\[IndentingNewLine]", 
    \(\(SetAttributes[fases, Listable];\)\), "\[IndentingNewLine]", 
    \(\(Show[
        GraphicsArray[{ListDensityPlot[amplitudes[dftlena], 
              DisplayFunction \[Rule] Identity], 
            ListDensityPlot[fases[dftlena], 
              DisplayFunction \[Rule] Identity]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {393, 187}];\)\)}], "Input"],

Cell["\<\
Vemos que en la zona central se concentran los valores mayores lo que indica \
que a medida que las frecuencias aumentan sus amplitudes disminuyen. Esto nos \
dice que las frecuencias m\[AAcute]s bajas contienen m\[AAcute]s informaci\
\[OAcute]n de la imagen que las frecuencias m\[AAcute]s altas. El espectro de \
fases es antisim\[EAcute]trico respecto al lugar central aunque esto no se \
aprecia en su imagen. Podemos comprobarlo representando parte de la fila \
central.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot[tmp = Take[\(fases[dftlena]\)[\([129]\)], {100, 158}], 
        Epilog \[Rule] {Line /@ 
              Table[{{k, 0}, {k, tmp[\([k]\)]}}, {k, 1, 59}], Hue[0], 
            PointSize[ .007], 
            Point /@ Table[{k, tmp[\([k]\)]}, {k, 1, 59}]}];\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot3D[amplitudes[dftlena], Mesh \[Rule] False, 
        PlotRange \[Rule] {0, 5}];\)\)], "Input"],

Cell[TextData[{
  "Hay que tener en cuenta que cada valor ",
  Cell[BoxData[
      \(TraditionalForm\`F(p, q)\)]],
  " de una 2D-DFT se obtiene sumando todos los valores ",
  Cell[BoxData[
      \(TraditionalForm\`f(m, n)\)]],
  " multiplicados por exponenciales complejas. Por eso, salvo en situaciones \
muy sencillas no es posible establecer correspondencias directas entre una \
imagen y su espectro de amplitudes. Pero lo que ya hemos visto es suficiente \
para poder dise\[NTilde]ar filtros en frecuencia."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado de im\[AAcute]genes en el dominio de la frecuencia", "Section"],

Cell[TextData[{
  "Consideremos una imagen digitalizada ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "=", \(\((f(m, n))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  ". La estrategia b\[AAcute]sica para dise\[NTilde]ar filtros en frecuencia \
consta de tres pasos:\n1 Obtener la 2D-DFT centrada de la imagen: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["f",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \(\((F(p, q))\)\_\(M\[Times]N\)\)}]}], 
        TraditionalForm]]],
  ".\n2 Definir la ",
  StyleBox["funci\[OAcute]n de transferencia",
    FontWeight->"Bold"],
  " del filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["H",
            FontWeight->"Bold"], "=", \(\((h(p, q))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  ".\n3 Calcular (la parte real de) la 2D-DFT inversa del producto \
t\[EAcute]rmino a t\[EAcute]rmino de ",
  StyleBox["F ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "por ",
  StyleBox["H",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y revertir el proceso de centrado."
}], "Text"],

Cell[TextData[{
  "Estas operaciones se corresponden con una convoluci\[OAcute]n \
c\[IAcute]clica en el dominio espacial. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula la convoluci\[OAcute]n c\[IAcute]clica de dos matrices con el \
comando ListConvolve[matriz1,matriz2,1]. La propiedad fundamental de la \
2D-DFT es que transforma la convoluci\[OAcute]n c\[IAcute]clica de dos \
matrices de iguales dimensiones en el producto matricial t\[EAcute]rmino a t\
\[EAcute]rmino de las transformadas. "
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\[ScriptCapitalF][matriz1\[SixPointedStar]matriz2] = 
      N\ M\ \[ScriptCapitalF][matriz1] \[ScriptCapitalF][matriz2]\)],
  FontWeight->"Bold"]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Hay que multiplicar por el factor ",
  Cell[BoxData[
      \(TraditionalForm\`N\ M\)]],
  " (producto de las dimensiones de las matrices) debido a los \
par\[AAcute]metros que usamos en el comando Fourier. Si us\[AAcute]ramos la \
opci\[OAcute]n por defecto de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no ser\[IAcute]a preciso hacer este ajuste. A efectos de representaci\
\[OAcute]n gr\[AAcute]fica de una imagen se trata de un ajuste innecesario."
}], "Text"],

Cell[BoxData[{
    \(\(a = Array[\((#1 + #2)\) &, {12, 6}];\)\), "\[IndentingNewLine]", 
    \(\(b = Array[\((#1*#2)\) &, {12, 6}];\)\), "\[IndentingNewLine]", 
    \(\(c = ListConvolve[a, b, 1];\)\), "\[IndentingNewLine]", 
    \(Fourier[c] \[Equal] 72  Fourier[a]*Fourier[b]\)}], "Input"],

Cell["\<\
Con valores no exactos hay que usar Chop[ ] debido a los errores de redondeo.\
\
\>", "Text"],

Cell[BoxData[{
    \(\(a = Table[Random[], {i, 24}, {j, 12}];\)\), "\[IndentingNewLine]", 
    \(\(b = Table[Random[], {i, 24}, {j, 12}];\)\), "\[IndentingNewLine]", 
    \(\(c = ListConvolve[a, b, 1];\)\), "\[IndentingNewLine]", 
    \(Simplify[
      Chop[Fourier[c] - 24*12  Fourier[a]*Fourier[b]] \[Equal] 0]\)}], "Input"],

Cell[TextData[{
  "Deducimos que el filtrado en frecuencia se corresponde con una convoluci\
\[OAcute]n en el dominio espacial. Pues llamando ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", \(\((h(p, q))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  " a la 2D-DFT inversa de la funci\[OAcute]n de transferencia ",
  StyleBox["H",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", se tiene que:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`F\ H = \(\(\[ScriptCapitalF](f)\) \(\[ScriptCapitalF](
            h)\) = \(\(1\/MN\) \(\[ScriptCapitalF](
                f\[SixPointedStar]\ h)\)\ \ \ \[DoubleLongRightArrow]
              f\[SixPointedStar]\ h = \(\(M\)\(\ \)\(N\)\(\ \)\(\(\
\[ScriptCapitalF]\^\(-1\)\)(F\ H)\)\(\ \)\)\)\)\)]]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[TextData[{
  "Es decir, la imagen que recuperamos despu\[EAcute]s del proceso de \
filtrado en frecuencia, es la misma que obtendr\[IAcute]amos realizando una \
convoluci\[OAcute]n c\[IAcute]clica de la imagen inicial con la \
funci\[OAcute]n ",
  StyleBox["h",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que se llama ",
  StyleBox["funci\[OAcute]n impulsiva",
    FontWeight->"Bold"],
  " del correspondiente filtro espacial. Es importante observar que para que \
la funci\[OAcute]n ",
  StyleBox["h",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sea real es preciso que la funci\[OAcute]n de transferencia ",
  StyleBox["H sea sim\[EAcute]trica respecto al lugar central (M/2+1,N/2+1).",
    
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " \nLo que acabamos de ver explica por qu\[EAcute] el dominio de la \
frecuencia suele proporcionar m\[EAcute]todos sencillos de realizar \
operaciones que no son f\[AAcute]ciles de implementar directamente en el \
dominio espacial. Veamos un ejemplo de esto."
}], "Text"],

Cell[CellGroupData[{

Cell["Filtro de media cero", "Subsection"],

Cell[TextData[{
  "El valor ",
  Cell[BoxData[
      \(TraditionalForm\`F(0, 0)\)]],
  " de la 2D-DFT de una imagen es igual a la media aritm\[EAcute]tica de \
todos los niveles de gris de la misma. Es muy f\[AAcute]cil conseguir que una \
imagen tenga un valor medio de niveles de gris igual a cero. Para ello \
definimos un filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["H",
            FontWeight->"Bold"], "=", \(\((h(p, q))\)\_\(M\[Times]N\)\)}], 
        TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "cuyos elementos son todos iguales a 1 excepto el que ocupa el mismo lugar \
que ",
  Cell[BoxData[
      \(TraditionalForm\`F(0, 0)\)]],
  " que se define igual a 0. "
}], "Text"],

Cell[BoxData[{
    \(\(micro = Import["\<micro.jpg\>"];\)\), "\[IndentingNewLine]", 
    \(\(Show[micro, ImageSize \[Rule]  .5*{500, 374}];\)\), "\n", 
    \(Dimensions[micro[\([1, 1]\)]]\)}], "Input"],

Cell[BoxData[{
    \(\(m = 374;\)\), "\[IndentingNewLine]", 
    \(\(n = 500;\)\), "\[IndentingNewLine]", 
    \(\(H = 
        1 - Normal[
            SparseArray[{{m\/2 + 1, n\/2 + 1} \[Rule] 1}, {m, n}]];\) (*\ 
      la\ funci\[OAcute]n\ de\ transferencia\ del\ filtro\ *) \), "\
\[IndentingNewLine]", 
    \(\(aux = 
        Normal[SparseArray[{{p_, q_} \[Rule] \((\(-1\))\)^\((p + q)\)}, {m, 
              n}]];\)\[IndentingNewLine] (*\ 
      multiplicar\ por\ la\ matriz\ "\<aux\>"\ equivale\ a\ centrar\ la\ \
transformada\ *) \), "\[IndentingNewLine]", 
    \(\(dft = Fourier[aux*micro[\([1, 1]\)]];\)\), "\[IndentingNewLine]", 
    \(\ \(filterimg = 
        aux*Chop[Re[InverseFourier[dft*H]]];\)\[IndentingNewLine] (*\ 
      calculamos\ las\ sumas\ de\ valores\ de\ grises\ de\ la\ imagen\ \
inicial\ y\ de\ la\ filtrada\ *) \), "\[IndentingNewLine]", 
    \(\(\({Total[Flatten[micro[\([1, 1]\)]]], Total[Flatten[filterimg]]} // 
      Chop\)\(\[IndentingNewLine]\)
    \) (*\ 
      en\ la\ imagen\ filtrada\ hay\ valores\ negativos\ *) \), "\
\[IndentingNewLine]", 
    \(\(\({Min[micro[\([1, 1]\)]], Min[filterimg]}\)\(\[IndentingNewLine]\)
    \) (*\ 
      en\ la\ representaci\[OAcute]n\ gr\[AAcute]fica\ de\ la\ imagen\ \
filtrada\ no\ se\ aprecia\ nada\ porque\ los\ niveles\ de\ grises\ se\ \
ajustan\ autom\[AAcute]ticamente\ para\ hacer\ la\ representaci\[OAcute]n\ y\ \
no\ se\ permiten\ valores\ negativos\ de\ gris\ *) \), "\[IndentingNewLine]", \

    \(\(ListDensityPlot[filterimg, 
        ImageSize \[Rule]  .5*{500, 374}];\)\)}], "Input"],

Cell["\<\
Podemos comprobar que la operaci\[OAcute]n realizada en el dominio de la \
frecuencia es una convoluci\[OAcute]n c\[IAcute]clica en el dominio espacial.\
\
\>", "Text"],

Cell[BoxData[{
    \(\(H = 
        1 - Normal[
            SparseArray[{{m\/2 + 1, n\/2 + 1} \[Rule] 1}, {m, 
                n}]];\)\), "\[IndentingNewLine]", 
    \(\(h = Chop[InverseFourier[H]];\)\), "\[IndentingNewLine]", 
    \(\(f = micro[\([1, 1]\)];\)\), "\[IndentingNewLine]", 
    \(\(F = Fourier[f] // Chop;\)\), "\[IndentingNewLine]", 
    \(\(convmicro = ListConvolve[f, h, 1];\)\), "\[IndentingNewLine]", 
    \(\(\(pro = \((m*n)\) InverseFourier[F*H] // 
          Chop;\)\(\[IndentingNewLine]\)
    \) (*\ 
      los\ errores\ de\ redondeo\ son\ del\ orden\ de\ 10^\(-7\)\ *) \), "\
\[IndentingNewLine]", 
    \(Simplify[Chop[pro - convmicro, 10\^\(-7\)] \[Equal] 0]\)}], "Input"],

Cell[BoxData[
    \(Clear[H, h, F, f, pro, convmicro, dft, filterimg, m, n, aux]\)], "Input"],

Cell["El siguiente comando implementa el filtro de media cero.", "Text"],

Cell[BoxData[
    \(\(filtromediacero[imagen_?MatrixQ, opts___] := 
        Module[{m = \(Dimensions[imagen]\)[\([1]\)], 
            n = \(Dimensions[imagen]\)[\([2]\)], aux, H, dft, 
            imgfilter}, \[IndentingNewLine]H = 
            1 - Normal[
                SparseArray[{{m\/2 + 1, n\/2 + 1} \[Rule] 1}, {m, 
                    n}]]; \[IndentingNewLine]aux = 
            Normal[SparseArray[{{p_, 
                      q_} \[Rule] \((\(-1\))\)^\((p + q)\)}, {m, 
                  n}]]; \[IndentingNewLine]dft = 
            Fourier[aux*imagen]; \[IndentingNewLine]\ 
          imgfilter = 
            aux*Chop[
                Re[InverseFourier[
                    dft*H]]]; \[IndentingNewLine]ListDensityPlot[imgfilter, 
            opts]];\)\)], "Input"],

Cell[BoxData[
    \(\(filtromediacero[micro[\([1, 1]\)]];\)\)], "Input"],

Cell["\<\
El siguiente comando muestra el efecto de un filtrado en frecuencia para un \
filtro ya previamente definido..\
\>", "Text"],

Cell[BoxData[{
    \(\(filtrogeneral[imagen_?MatrixQ, filtro_?MatrixQ, opts___] := 
        Module[{m = \(Dimensions[imagen]\)[\([1]\)], 
              n = \(Dimensions[imagen]\)[\([2]\)], aux, dft, 
              imgfilter}, \[IndentingNewLine]aux = 
              Normal[SparseArray[{{p_, 
                        q_} \[Rule] \((\(-1\))\)^\((p + q)\)}, {m, 
                    n}]]; \[IndentingNewLine]dft = 
              Fourier[aux*imagen]; \[IndentingNewLine]\ 
            imgfilter = 
              aux*Chop[
                  Re[InverseFourier[
                      dft*filtro]]]; \[IndentingNewLine]ListDensityPlot[
              imgfilter, opts]] /; 
          Dimensions[imagen] \[Equal] 
            Dimensions[filtro];\)\), "\[IndentingNewLine]", 
    \(filtrogeneral[otraima_, otrofilt_, 
        opts___] := "\<La imagen y el filtro deben ser matrices con iguales \
dimensiones\>"\)}], "Input"],

Cell[TextData[{
  "El siguiente comando permite simetrizar una matriz ",
  Cell[BoxData[
      \(TraditionalForm\`M\[Times]N\)]],
  " respecto del valor central (M/2+1,N/2+1). Es \[UAcute]til para construir \
la funci\[OAcute]n de transferencia de un filtro."
}], "Text"],

Cell[BoxData[
    \(simetrizar[matriz_?MatrixQ] := 
      Module[{m = \(Dimensions[matriz]\)[\([1]\)], 
          n = \(Dimensions[matriz]\)[\([2]\)], aux, temp, fila1, col1}, 
        fila1 = Rest[matriz[\([1]\)]]; \[IndentingNewLine]col1 = 
          matriz[\([All, 1]\)]; \[IndentingNewLine]temp = 
          TakeMatrix[matriz, {2, 2}, {m, n}]; \[IndentingNewLine]aux = 
          Map[Reverse, 
            Reverse[temp]]; \[IndentingNewLine]aux = \((temp + 
                aux)\)*0.5; \ \[IndentingNewLine]aux = 
          AppendColumns[{fila1}, aux]; \[IndentingNewLine]AppendRows[
          Partition[col1, 1], aux]]\)], "Input"],

Cell[BoxData[{
    \(\(m = Table[Random[], {i, 6}, {j, 6}];\)\), "\[IndentingNewLine]", 
    \(MatrixForm[m]\), "\[IndentingNewLine]", 
    \(simetrizar[m] // MatrixForm\  (*\ 
      sim\[EAcute]trica\ respecto\ del\ lugar\ \((4, 
          4)\)\ *) \), "\[IndentingNewLine]", 
    \(Clear[m, micro]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros de paso bajo y paso alto", "Subsection"],

Cell["\<\
Las frecuencias bajas en la 2D-DFT de una imagen se corresponden con zonas \
homog\[EAcute]neas de la imagen con niveles de gris uniforme, mientras que \
las frecuencias altas est\[AAcute]n relacionadas con los perfiles y detalles \
en los que se producen bruscos cambios de luminosidad, lo que tambi\[EAcute]n \
puede ser debido al posible ruido que pueda tener la imagen. Como su nombre \
indica, un filtro de paso bajo solamente deja pasar las frecuencias bajas, \
por lo que su resultado es que los perfiles se muestran borrosos y la imagen \
obtenida est\[AAcute] formada por planos con tonalidades de gris uniformes. \
Vamos a considerar dos tipos de filtros de paso bajo.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Filtro ideal de paso bajo", "Subsubsection"],

Cell[TextData[{
  "Se trata de un filtro que deja pasar todas las frecuencias por debajo de \
un umbral y elimina las restantes. Teniendo en cuenta c\[OAcute]mo est\
\[AAcute]n representadas las frecuencias en la transformada, un filtro de \
paso bajo ideal est\[AAcute] dado por una funci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 1\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v) < D\_0\%2\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 0\)]],
  " en otro caso. Donde ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v)\)]],
  " es la distancia eucl\[IAcute]dea medida desde el origen de la \
transformada de Fourier que se supone centrada. De forma m\[AAcute]s expl\
\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 1\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(\((u - M/2 - 1)\)\^2 + \((v - N/2 - 1)\)\^2\) < 
        D\_0\%2\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, v) = 0\)]],
  " en otro caso. Donde hemos supuesto que las dimensiones de la imagen son \
",
  Cell[BoxData[
      \(TraditionalForm\`M\[Times]N\)]],
  ". La cantidad ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " es la frecuencia de corte. Este filtro deja pasar inalteradas todas las \
frecuencias en un c\[IAcute]rculo de radio ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " y elimina totalmente todas las frecuencias fuera de dicho \
c\[IAcute]rculo. Este comportamiento no puede lograrse con circuitos electr\
\[OAcute]nicos, de ah\[IAcute] su nombre \"ideal\", aunque s\[IAcute] puede \
implementarse en un ordenador. Veamos un ejemplo. Seguidamente importamos una \
imagen."
}], "Text"],

Cell[BoxData[{
    \(\(Import["\<cerradura.jpg\>"];\)\), "\n", 
    \(\(candado = %[\([1, 1]\)] /. 
          x_?VectorQ \[RuleDelayed] x[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[candado, 
        ImageSize \[Rule] {232, 154}];\)\), "\[IndentingNewLine]", 
    \(Dimensions[candado]\)}], "Input"],

Cell["El siguiente comando implementa un filtro ideal paso bajo.", "Text"],

Cell[BoxData[
    \(\(\(filtroidealpasobajo[d_]\)[M_, N_] := 
        Table[If[\@\(\((u - M/2 - 1)\)\^2 + \((v - N/2 - 1)\)^2\) < d^2, 1.0, 
            0.0], {u, 1, M}, {v, 1, N}];\)\)], "Input"],

Cell["\<\
Veamos el resultado de filtrar la imagen anterior con distintas frecuencias \
de corte.\
\>", "Text"],

Cell[BoxData[{
    \(\(graf[k_] := 
        filtrogeneral[candado, \(filtroidealpasobajo[k]\)[154, 232], 
          ImageSize \[Rule] {232, 154}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{{graf[4], graf[5]}, {graf[6], graf[7]}}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] 2*{232, 154}];\)\)}], "Input"],

Cell[TextData[{
  "Observa el t\[IAcute]pico efecto de ",
  StyleBox["anillado",
    FontSlant->"Italic"],
  " que produce este filtro. Podemos explicar este efecto considerando el \
filtrado espacial por convoluci\[OAcute]n correspondiente a este filtro en \
frecuencia."
}], "Text"],

Cell[BoxData[{
    \(\(H = \(filtroidealpasobajo[4]\)[154, 
          232];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[H, ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell["\<\
Construimos la funci\[OAcute]n impulsiva del correspondiente filtro espacial \
y la representamos gr\[AAcute]ficamente.\
\>", "Text"],

Cell[BoxData[{
    \(\(h = InverseFourier[centrar[H]] // Chop;\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[centrar[h], 
        ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell["\<\
En esta imagen ya aparecen los anillos. Tambi\[EAcute]n podemos representarla \
en 3D.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlot3D[centrar[h], 
        PlotRange \[Rule] {{62, 172}, {23, 133}, All}];\)\)], "Input"],

Cell["\<\
Pero eso no es a\[UAcute]n una explicaci\[OAcute]n completa. Consideremos una \
imagen elemental formada por 5 niveles positivos de gris y los dem\[AAcute]s \
nulos.\
\>", "Text"],

Cell[BoxData[{
    \(\(id[{m_, n_}, {M_, N_}] := 
        Normal[SparseArray[{{m, n} \[Rule] 1}, {M, 
              N}]];\)\), "\[IndentingNewLine]", 
    \(\(img = 
        id[{78, 117}, {154, 232}] + id[{78, 117} + {45, 45}, {154, 232}] + 
          id[{78, 117} - {45, 45}, {154, 232}] + 
          id[{78, 117} + {\(-45\), 45}, {154, 232}] + 
          id[{78, 117} - {\(-45\), 45}, {154, 
              232}];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[img, ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell[TextData[{
  "Ahora vamos a obtener la convoluci\[OAcute]n de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "(la respuesta impulsiva del filtro) con la imagen elemental anterior y a \
representar la imagen obtenida en este proceso de filtrado espacial."
}], "Text"],

Cell[BoxData[{
    \(\(convimg = ListConvolve[img, h, 1];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[convimg, ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell[TextData[{
  "Como puedes ver el efecto de la convoluci\[OAcute]n es replicar la imagen \
de ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " ",
  "en cada uno de los cinco puntos que forman nuestra imagen elemental: en \
vez de un anillo, ahora tenemos cinco. Podemos ya entender el efecto de \
anillado: se produce debido a las interferencias mutuas de muchos anillos \
entre s\[IAcute]."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtro gausiano de paso bajo", "Subsubsection"],

Cell["\<\
El siguiente comando muestrea una funci\[OAcute]n y permite elegir el n\
\[UAcute]mero de muestras en cada eje.\
\>", "Text"],

Cell[BoxData[
    \(samples[f_, {a_, b_}, {c_, d_}, {m_, n_}] := 
      Outer[f, Range[N[a], N[b - \(b - a\)\/m], N[\(b - a\)\/m]], 
        Range[N[c], N[d - \(d - c\)\/n], N[\(d - c\)\/n]]]\)], "Input"],

Cell[TextData[{
  "Podemos costruir un filtro de paso bajo con una gausiana. Estos filtros \
son de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`H(u, 
          v) = \[ExponentialE]\^\(\(-\(\(D\^2\)(u, v)\)\)/2  D\_0\%2\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`D(u, v)\)]],
  " es la distancia eucl\[IAcute]dea medida desde el origen de la \
transformada de Fourier que se supone centrada. El n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " es la frecuencia de corte del filtro. Este filtro no elimina totalmente \
las frecuencias mayores que ",
  Cell[BoxData[
      \(TraditionalForm\`D\_0\)]],
  " ni tampoco deja pasar inalteradas las frecuencias menores; lo que hace es \
disminuir las frecuencias de forma proporcional a su distancia al centro de \
la transformada."
}], "Text"],

Cell["\<\
El siguiente comando implementa un filtro gausiano de paso bajo.\
\>", "Text"],

Cell[BoxData[
    \(\(\(filtrogausianopasobajo[d_]\)[P_, Q_] := 
        Table[N[Exp[\(-\(\(\((u - P/2 - 1)\)\^2 + \((v - Q/2 - 1)\)\^2\)\/\(2\
\ d\^2\)\)\)]], {u, 1, P}, {v, 1, Q}] // Chop;\)\)], "Input"],

Cell["\<\
Veamos el resultado de filtrar la imagen anterior con distintas frecuencias \
de corte.\
\>", "Text"],

Cell[BoxData[{
    \(\(graf[k_] := 
        filtrogeneral[candado, \(filtrogausianopasobajo[k]\)[154, 232], 
          ImageSize \[Rule] {232, 154}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{{graf[5], graf[6]}, {graf[7], graf[8]}}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] 2*{232, 154}];\)\)}], "Input"],

Cell["\<\
Como puede verse, se han perdido casi totalmente los perfiles y la imagen ha \
quedado reducida a unas pocas zonas planas con tonalidades de gris uniforme. \
Adem\[AAcute]s no se produce efecto de anillado. Esto se debe a que este \
filtro no introduce una discontinuidad brusca como hace el filtro ideal de \
paso bajo. Podemos comprobarlo representando los dos filtros en 3D.\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{ListPlot3D[\(filtroidealpasobajo[4]\)[154, 232], 
              DisplayFunction \[Rule] Identity, 
              PlotRange \[Rule] {{87, 147}, {48, 108}, All}], 
            ListPlot3D[\(filtrogausianopasobajo[4]\)[154, 232], 
              PlotRange \[Rule] {{87, 147}, {48, 108}, All}, 
              DisplayFunction \[Rule] Identity]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] 2*{232, 154}];\)\)], "Input"],

Cell["\<\
El filtro espacial que corresponde a un filtro gausiano de paso bajo es tambi\
\[EAcute]n un filtro con un n\[UAcute]cleo de convoluci\[OAcute]n gausiano. \
Esto se debe a que la 2D-DFT transformas n\[UAcute]cleos gausianos en n\
\[UAcute]cleos gausianos. \
\>", "Text"],

Cell[BoxData[{
    \(\(H = \(filtrogausianopasobajo[4]\)[154, 
          232];\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[H, ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell["\<\
Construimos la funci\[OAcute]n impulsiva del correspondiente filtro espacial \
y la representamos gr\[AAcute]ficamente.\
\>", "Text"],

Cell[BoxData[{
    \(\(h = InverseFourier[centrar[H]] // Chop;\)\), "\[IndentingNewLine]", 
    \(\(ListDensityPlot[centrar[h], 
        ImageSize \[Rule] {232, 154}];\)\)}], "Input"],

Cell[TextData[{
  "En esta imagen no aparecen anillos. Representando ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "en 3D podemos comprobar que se trata de una gausiana."
}], "Text"],

Cell[BoxData[
    \(\(ListPlot3D[centrar[h], 
        PlotRange \[Rule] {{62, 172}, {23, 133}, All}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros de paso alto", "Subsubsection"],

Cell[TextData[{
  "Lo contrario de un filtro de paso bajo es uno de paso alto que solamente \
deja pasar las frecuencias altas, con el resultado de que acent\[UAcute]a los \
perfiles y los detalles finos de la imagen. Es f\[AAcute]cil convertir un \
filtro de paso bajo en uno de paso alto: si ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " es un filtro de paso bajo, ",
  Cell[BoxData[
      \(TraditionalForm\`Max[F] - F\)]],
  " es un filtro de paso alto. Puedes cmprobarlo ejecutando el siguiente \
comando."
}], "Text"],

Cell[BoxData[{
    \(\(graf[k_] := 
        filtrogeneral[candado, 1 - \(filtrogausianopasobajo[k]\)[154, 232], 
          ImageSize \[Rule] {232, 154}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{{graf[4], graf[6]}, {graf[8], graf[10]}}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] 2*{232, 154}];\)\)}], "Input"],

Cell["\<\
Ahora se han perdido tonalidades de gris pero los perfiles de la imagen se \
muestran n\[IAcute]tidos. Esto se aprecia mucho mejor con la siguiente \
imagen.\
\>", "Text"],

Cell[BoxData[{
    \(\(letras = Import["\<oculista.jpg\>"];\)\), "\[IndentingNewLine]", 
    \(\(Show[%, 
        ImageSize \[Rule]  .33*{500, 500}];\)\), "\[IndentingNewLine]", 
    \(Dimensions[letras[\([1, 1]\)]]\)}], "Input"],

Cell[BoxData[{
    \(\(graf[k_] := 
        filtrogeneral[letras[\([1, 1]\)], 
          1 - \(filtrogausianopasobajo[k]\)[500, 500], 
          ImageSize \[Rule]  .33 {500, 500}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{graf[15], graf[30], graf[60]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {500, 0.33*500}];\)\)}], "Input"],

Cell[TextData[StyleBox["Otros tipos de filtros", "Subsubsection"]], "Text"],

Cell[TextData[{
  "Los tipos de filtros que acabamos de ver son los m\[AAcute]s \
b\[AAcute]sicos. En la pr\[AAcute]ctica se usan una gran variedad de filtros \
dise\[NTilde]ados para lograr determinados efectos en una imagen. Si est\
\[AAcute]s interesado en este tema debes consultar el libro ",
  StyleBox["Digital Image Processing",
    FontSlant->"Italic"],
  " de R.C. Gonzalez y R.E. Woods (2\.ba Ed., Prentice Hall, 2002). Acabar\
\[EAcute] este cuaderno con un filtro dise\[NTilde]ado de forma que disminuye \
el efecto de las frecuencias bajas y destaca el de las altas. Como las \
frecuencias bajas est\[AAcute]n asociadas con la iluminaci\[OAcute]n y las \
altas con el contraste, el efecto de este filtro es comprimir el rango din\
\[AAcute]mico y aumentar el contraste. El filtro va a depender de 4 par\
\[AAcute]metros."
}], "Text"],

Cell[BoxData[
    \(\(\(filtro[a_, b_, c_, d_]\)[P_, Q_] := 
        Table[\((a - b)\) \((1 - 
                    N[Exp[\(-\(\(\((u - P/2 - 1)\)\^2 + \((v - Q/2 - \
1)\)\^2\)\/d\^2\)\)]])\) + c*b, {u, 1, P}, {v, 1, Q}] // Chop;\)\)], "Input"],

Cell[BoxData[{
    \(\(puente = Import["\<puente.dat\>"];\)\), "\[IndentingNewLine]", 
    \(\(Show[
        GraphicsArray[{ListDensityPlot[puente, 
              DisplayFunction \[Rule] Identity, 
              ImageSize \[Rule]  .5*{512, 512}], 
            filtrogeneral[puente, \(filtro[2.5, 0.5, 10.0, 60.0]\)[512, 512], 
              DisplayFunction \[Rule] Identity, 
              ImageSize \[Rule]  .5*{512, 512}]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule] {512, 0.5*512}];\)\)}], "Input"],

Cell["\<\
La imagen a la derecha es m\[AAcute]s n\[IAcute]tida y tiene un mejor \
equilibrio de niveles de gris.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 96, 2, 174, "Title"],

Cell[CellGroupData[{
Cell[1875, 57, 41, 0, 93, "Section"],
Cell[1919, 59, 181, 4, 67, "Text"],
Cell[2103, 65, 618, 12, 228, "Input",
  InitializationCell->True],
Cell[2724, 79, 170, 3, 124, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2931, 87, 65, 0, 93, "Section"],
Cell[2999, 89, 1409, 43, 93, "Text"],
Cell[4411, 134, 933, 21, 85, "NumberedEquation"],
Cell[5347, 157, 2066, 68, 147, "Text"],
Cell[7416, 227, 82, 1, 41, "Text"],
Cell[7501, 230, 866, 20, 88, "NumberedEquation"],
Cell[8370, 252, 1311, 42, 94, "Text"],
Cell[9684, 296, 328, 9, 41, "Text"],

Cell[CellGroupData[{
Cell[10037, 309, 59, 0, 78, "Subsection"],
Cell[10099, 311, 295, 7, 67, "Text"],
Cell[10397, 320, 949, 22, 85, "NumberedEquation"],
Cell[11349, 344, 620, 14, 100, "Text"],
Cell[11972, 360, 711, 15, 180, "Input"],
Cell[12686, 377, 102, 3, 41, "Text"],
Cell[12791, 382, 451, 10, 176, "Input"],
Cell[13245, 394, 159, 4, 98, "Input"],
Cell[13407, 400, 364, 8, 93, "Text"],
Cell[13774, 410, 104, 2, 98, "Input"],
Cell[13881, 414, 153, 5, 41, "Text"],
Cell[14037, 421, 167, 3, 98, "Input"],
Cell[14207, 426, 298, 9, 41, "Text"],
Cell[14508, 437, 146, 3, 98, "Input"],
Cell[14657, 442, 111, 3, 41, "Text"],
Cell[14771, 447, 115, 2, 72, "Input"],
Cell[14889, 451, 387, 7, 176, "Input"],
Cell[15279, 460, 254, 5, 124, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15570, 470, 58, 0, 78, "Subsection"],
Cell[15631, 472, 661, 18, 93, "Text"],
Cell[16295, 492, 659, 16, 84, "NumberedEquation"],
Cell[16957, 510, 122, 3, 41, "Text"],
Cell[17082, 515, 1413, 37, 85, "NumberedEquation"],
Cell[18498, 554, 228, 4, 67, "Text"],
Cell[18729, 560, 236, 5, 124, "Input"],
Cell[18968, 567, 171, 3, 67, "Text"],
Cell[19142, 572, 200, 3, 98, "Input"],
Cell[19345, 577, 157, 5, 41, "Text"],
Cell[19505, 584, 260, 5, 150, "Input"],
Cell[19768, 591, 85, 1, 41, "Text"],
Cell[19856, 594, 258, 4, 150, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20151, 603, 66, 0, 78, "Subsection"],
Cell[20220, 605, 647, 19, 93, "Text"],
Cell[20870, 626, 200, 5, 39, "Text"],
Cell[21073, 633, 555, 15, 93, "Text"],
Cell[21631, 650, 512, 17, 42, "Text"],
Cell[22146, 669, 369, 9, 67, "Text"],
Cell[22518, 680, 406, 8, 176, "Input"],
Cell[22927, 690, 99, 2, 41, "Text"],
Cell[23029, 694, 617, 14, 280, "Input"],
Cell[23649, 710, 368, 10, 41, "Text"],
Cell[24020, 722, 531, 10, 202, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24600, 738, 100, 2, 93, "Section"],
Cell[24703, 742, 1151, 17, 223, "Text"],
Cell[25857, 761, 1020, 20, 358, "Input"],
Cell[26880, 783, 284, 5, 67, "Text"],
Cell[27167, 790, 139, 2, 98, "Input"],
Cell[27309, 794, 319, 5, 67, "Text"],
Cell[27631, 801, 262, 6, 124, "Input"],
Cell[27896, 809, 292, 5, 67, "Text"],
Cell[28191, 816, 139, 3, 41, "Text"],
Cell[28333, 821, 137, 2, 98, "Input"],
Cell[28473, 825, 417, 7, 93, "Text"],
Cell[28893, 834, 262, 6, 124, "Input"],
Cell[29158, 842, 221, 4, 67, "Text"],
Cell[29382, 848, 167, 3, 41, "Text"],
Cell[29552, 853, 161, 3, 98, "Input"],
Cell[29716, 858, 222, 4, 67, "Text"],
Cell[29941, 864, 262, 6, 124, "Input"],
Cell[30206, 872, 68, 0, 41, "Text"],
Cell[30277, 874, 239, 5, 98, "Input"],
Cell[30519, 881, 159, 3, 41, "Text"],
Cell[30681, 886, 285, 7, 124, "Input"],
Cell[30969, 895, 38, 0, 41, "Text"],
Cell[31010, 897, 437, 14, 41, "Text"],
Cell[31450, 913, 908, 21, 127, "Text"],
Cell[32361, 936, 236, 4, 67, "Text"],
Cell[32600, 942, 214, 4, 98, "Input"],
Cell[32817, 948, 153, 3, 41, "Text"],
Cell[32973, 953, 342, 8, 163, "Input"],
Cell[33318, 963, 93, 2, 41, "Text"],
Cell[33414, 967, 228, 4, 124, "Input"],
Cell[33645, 973, 262, 6, 124, "Input"],
Cell[33910, 981, 619, 9, 145, "Text"],
Cell[34532, 992, 395, 6, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34964, 1003, 42, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[35031, 1007, 44, 0, 78, "Subsection"],
Cell[35078, 1009, 30, 0, 41, "Text"],
Cell[35111, 1011, 597, 15, 78, "NumberedEquation"],
Cell[35711, 1028, 185, 6, 41, "Text"],
Cell[35899, 1036, 597, 15, 78, "NumberedEquation"],
Cell[36499, 1053, 447, 13, 72, "Text"],
Cell[36949, 1068, 658, 11, 286, "Input"],
Cell[37610, 1081, 51, 0, 41, "Text"],
Cell[37664, 1083, 207, 4, 98, "Input"],
Cell[37874, 1089, 190, 4, 67, "Text"],
Cell[38067, 1095, 144, 2, 72, "Input"],
Cell[38214, 1099, 358, 6, 93, "Text"],
Cell[38575, 1107, 112, 2, 72, "Input"],
Cell[38690, 1111, 182, 4, 67, "Text"],
Cell[38875, 1117, 414, 8, 202, "Input"],
Cell[39292, 1127, 300, 5, 67, "Text"],
Cell[39595, 1134, 453, 9, 176, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40097, 1149, 105, 3, 93, "Section"],
Cell[40205, 1154, 261, 5, 67, "Text"],
Cell[40469, 1161, 158, 3, 98, "Input"],
Cell[40630, 1166, 103, 3, 41, "Text"],
Cell[40736, 1171, 296, 7, 124, "Input"],
Cell[41035, 1180, 113, 3, 41, "Text"],
Cell[41151, 1185, 306, 6, 150, "Input"],
Cell[41460, 1193, 218, 4, 67, "Text"],
Cell[41681, 1199, 133, 3, 72, "Input"],
Cell[41817, 1204, 593, 10, 202, "Input"],
Cell[42413, 1216, 129, 3, 41, "Text"],
Cell[42545, 1221, 65, 0, 41, "Text"],
Cell[42613, 1223, 158, 3, 98, "Input"],
Cell[42774, 1228, 101, 1, 41, "Text"],
Cell[42878, 1231, 180, 4, 98, "Input"],
Cell[43061, 1237, 127, 3, 41, "Text"],
Cell[43191, 1242, 186, 4, 98, "Input"],
Cell[43380, 1248, 151, 3, 41, "Text"],
Cell[43534, 1253, 268, 5, 124, "Input"],
Cell[43805, 1260, 112, 3, 41, "Text"],
Cell[43920, 1265, 422, 7, 176, "Input"],
Cell[44345, 1274, 130, 3, 41, "Text"],
Cell[44478, 1279, 204, 4, 98, "Input"],
Cell[44685, 1285, 240, 4, 124, "Input"],
Cell[44928, 1291, 85, 2, 41, "Text"],
Cell[45016, 1295, 158, 3, 98, "Input"],
Cell[45177, 1300, 68, 0, 41, "Text"],
Cell[45248, 1302, 620, 11, 280, "Input"],
Cell[45871, 1315, 499, 8, 119, "Text"],
Cell[46373, 1325, 297, 5, 124, "Input"],
Cell[46673, 1332, 124, 2, 72, "Input"],
Cell[46800, 1336, 524, 11, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47361, 1352, 78, 0, 93, "Section"],
Cell[47442, 1354, 1528, 48, 182, "Text"],
Cell[48973, 1404, 529, 10, 93, "Text"],
Cell[49505, 1416, 231, 4, 35, "Text"],
Cell[49739, 1422, 498, 11, 93, "Text"],
Cell[50240, 1435, 290, 4, 150, "Input"],
Cell[50533, 1441, 103, 3, 41, "Text"],
Cell[50639, 1446, 326, 5, 150, "Input"],
Cell[50968, 1453, 484, 14, 68, "Text"],
Cell[51455, 1469, 427, 8, 48, "Text"],
Cell[51885, 1479, 1044, 25, 186, "Text"],

Cell[CellGroupData[{
Cell[52954, 1508, 42, 0, 78, "Subsection"],
Cell[52999, 1510, 760, 22, 94, "Text"],
Cell[53762, 1534, 201, 3, 124, "Input"],
Cell[53966, 1539, 1572, 31, 511, "Input"],
Cell[55541, 1572, 178, 4, 41, "Text"],
Cell[55722, 1578, 697, 14, 275, "Input"],
Cell[56422, 1594, 93, 1, 72, "Input"],
Cell[56518, 1597, 72, 0, 41, "Text"],
Cell[56593, 1599, 776, 16, 284, "Input"],
Cell[57372, 1617, 72, 1, 72, "Input"],
Cell[57447, 1620, 134, 3, 41, "Text"],
Cell[57584, 1625, 912, 18, 306, "Input"],
Cell[58499, 1645, 271, 6, 67, "Text"],
Cell[58773, 1653, 636, 11, 280, "Input"],
Cell[59412, 1666, 313, 6, 150, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59762, 1677, 54, 0, 78, "Subsection"],
Cell[59819, 1679, 702, 10, 145, "Text"],

Cell[CellGroupData[{
Cell[60546, 1693, 50, 0, 67, "Subsubsection"],
Cell[60599, 1695, 1718, 44, 249, "Text"],
Cell[62320, 1741, 318, 6, 150, "Input"],
Cell[62641, 1749, 74, 0, 41, "Text"],
Cell[62718, 1751, 196, 3, 142, "Input"],
Cell[62917, 1756, 111, 3, 41, "Text"],
Cell[63031, 1761, 399, 7, 150, "Input"],
Cell[63433, 1770, 284, 7, 67, "Text"],
Cell[63720, 1779, 178, 3, 98, "Input"],
Cell[63901, 1784, 143, 3, 41, "Text"],
Cell[64047, 1789, 183, 3, 98, "Input"],
Cell[64233, 1794, 110, 3, 41, "Text"],
Cell[64346, 1799, 116, 2, 72, "Input"],
Cell[64465, 1803, 189, 4, 67, "Text"],
Cell[64657, 1809, 519, 10, 176, "Input"],
Cell[65179, 1821, 393, 10, 67, "Text"],
Cell[65575, 1833, 166, 2, 98, "Input"],
Cell[65744, 1837, 469, 12, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66250, 1854, 53, 0, 67, "Subsubsection"],
Cell[66306, 1856, 135, 3, 41, "Text"],
Cell[66444, 1861, 204, 3, 176, "Input"],
Cell[66651, 1866, 837, 20, 150, "Text"],
Cell[67491, 1888, 88, 2, 41, "Text"],
Cell[67582, 1892, 205, 3, 129, "Input"],
Cell[67790, 1897, 111, 3, 41, "Text"],
Cell[67904, 1902, 402, 7, 150, "Input"],
Cell[68309, 1911, 401, 6, 93, "Text"],
Cell[68713, 1919, 498, 9, 228, "Input"],
Cell[69214, 1930, 280, 5, 67, "Text"],
Cell[69497, 1937, 181, 3, 98, "Input"],
Cell[69681, 1942, 143, 3, 41, "Text"],
Cell[69827, 1947, 183, 3, 98, "Input"],
Cell[70013, 1952, 286, 9, 41, "Text"],
Cell[70302, 1963, 116, 2, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70455, 1970, 45, 0, 67, "Subsubsection"],
Cell[70503, 1972, 532, 12, 93, "Text"],
Cell[71038, 1986, 407, 7, 150, "Input"],
Cell[71448, 1995, 181, 4, 67, "Text"],
Cell[71632, 2001, 229, 4, 124, "Input"],
Cell[71864, 2007, 426, 8, 176, "Input"],
Cell[72293, 2017, 75, 0, 52, "Text"],
Cell[72371, 2019, 847, 14, 171, "Text"],
Cell[73221, 2035, 243, 4, 167, "Input"],
Cell[73467, 2041, 537, 10, 254, "Input"],
Cell[74007, 2053, 126, 3, 41, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

